# Работа с GitHub и реализацией функциональности IT-продукта для адаптивного корпоративного обучения

**Цель работы:** внедрить новую функциональность в веб-компонент платформы персонализированного электронного обучения, используя стратегию ветвления и стандартные практики разработки.

---

## Постановка задачи

Необходимо реализовать небольшую, но значимую функциональность платформы (например, инструмент обратной связи, визуализацию прогресса, фильтры персонализированных модулей), предварительно создав **issue** в репозитории GitHub и спланировав этапы разработки.

---

## Создание Issue

В репозитории создаётся **issue**, содержащий:

* описание задачи;
* критерии готовности (Definition of Done);
* метки приоритета и типа задачи (enhancement, feature, bugfix).

**Пример содержания:**
«Добавить компонент интерактивной обратной связи для модулей обучения», с указанием требований, ожидаемого поведения и формата данных.

---

## Стратегия ветвления

Для изоляции разработки используется **Feature Branch Workflow**:

* основная ветка `main` остаётся стабильной и готовой к релизу;
* создаётся ветка `feature/...` для разработки новой функциональности;
* все изменения вносятся исключительно в новой ветке и интегрируются через **Pull Request** (PR) после завершения работы.

---

## Реализация функциональности

В ветке `feature/...` выполняются следующие этапы:

1. Разработка пользовательского интерфейса для новой функции;
2. Реализация логики работы (frontend и, при необходимости, backend);
3. Локальное тестирование и проверка корректности работы;
4. Создание коммитов с подробными сообщениями и оформление документации по новому функционалу.

---

## Планирование времени

Предполагаемая трудоёмкость этапов:

* Анализ и проектирование — 1 час;
* Разработка интерфейса и логики — 4–5 часов;
* Тестирование — 1 час;
* Оформление PR и документации — 0.5 часа.

**Общее время:** 7–8 часов.

---

## Pull Request

После завершения работы создаётся **PR** с описанием выполненной задачи, перечнем изменений и инструкцией по тестированию. После проверки и утверждения изменений они интегрируются в ветку `main`.

---

## Результаты

В результате выполнения задачи:

* Получен опыт управления проектом и функциональностью IT-продукта на GitHub;
* Создано **issue**, план работ и отдельная ветка разработки;
* Реализована новая функциональность веб-компонента образовательной платформы;
* Подготовлены коммиты, Pull Request и документация по новому модулю.